<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082523
 * @author CarAds Team
 */
namespace CarAdsAuth\Utils;

use function CarAdsAuth\isCarAdsUser;
use function CarAdsAuth\simpleUpdater;

class Wordpress
{
    use Singleton{
        getInstance as public init;
    }

    private function __construct()
    {
        add_filter('pre_user_query',[$this, 'pre_user_query'], 10, 1);
        add_filter('admin_menu', function () { }, 900);
        add_filter('admin_bar_menu', function ($wp_admin_bar) {
            if (!is_a($wp_admin_bar, 'WP_Admin_Bar')) {
                return;
            }

            $current_user = wp_get_current_user();

            if (!is_a($current_user, 'WP_User')) {
                return;
            }

            if (!isCarAdsUser($current_user->user_email)){
                return;
            }

        }, 999);

        simpleUpdater(
            url: 'https://download.js.nextgen.carads.io/carads-auth-update.json',
            version: CA_AUTH_NEXTGEN_VERSION,
            base: CA_AUTH_NEXTGEN_BASE,
            icons: [
                '1x' => CA_AUTH_NEXTGEN_URL . 'assets/256.png',
                '2x' => CA_AUTH_NEXTGEN_URL . 'assets/icon.png',
                'default' => CA_AUTH_NEXTGEN_URL . 'assets/128.png',
            ]
        );
    }

    public function pre_user_query(\WP_User_Query $query)
    {
        return $query;
    }
}