<?php
namespace CarAdsMail\Elementor;
use CarAdsMail\Basic\Singleton;
use ElementorPro\Modules\Forms\Classes\Form_Record;

class Mailer
{
    use Singleton;

    private function __construct()
    {
        add_action('elementor_pro/forms/new_record', [$this, 'beforeSendMail'], 10, 2);
    }



    /**
     * @throws ReflectionException
     */
    public function beforeSendMail(?Form_Record $record = null): void
    {
        $reflection = new \ReflectionClass($record);
        $property   = $reflection->getProperty('fields');
        $property->setAccessible(true);


        $formData = $property->getValue($record);
        $tmpForm = new stdClass;

        $cid = null;
        $slug = null;

        foreach ($formData as $key => $value) {
            switch ($key) {
                case 'cid':
                    $cid = $value['value'];
                    break;
                case 'slug':
                    $slug = $value['value'];
                    break;
                default:
                    $tmpForm->{$key} = $value['value'];
                    break;
            }
        }

        if($cid !== null && $slug === null){
            $slug = 'any_form';
        }

        if($cid === null || $slug === null){
            return;
        }

        $this->sendLead($cid, $slug, $tmpForm);
    }


    private function sendLead($cid, $slug, $data): stdClass
    {
        $url = "https://nextgen.carads.io/leads/{$cid}/{$slug}";

        $data = (new \WP_Http())->post($url, ['body' => json_encode($data), 'data_format' => 'body']);

        return json_decode($data['body'] ?? [], true);
    }
}