<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20082523
 * @author CarAds Team
 */

use CarAdsMail\Elementor\Mailer;
use function CarAdsMail\Basic\simpleUpdater;

return new class{
    public function __construct()
    {
        $this->register_updates();
        Mailer::getInstance();
    }

    public function register_updates(): void
    {
        if(!CA_MAIL_TEST){
            simpleUpdater(
                url: 'https://download.js.nextgen.carads.io/carads-mail-update.json',
                version: CA_MAIL_NEXTGEN_VERSION,
                base: CA_MAIL_NEXTGEN_BASE,
                icons: [
                    '1x' => CA_MAIL_NEXTGEN_URL . 'assets/256.png',
                    '2x' => CA_MAIL_NEXTGEN_URL . 'assets/icon.png',
                    'default' => CA_MAIL_NEXTGEN_URL . 'assets/128.png',
                ]
            );
        }
    }
};