<?php
/**
 * @copyright  Copyright (C) 2026 CarShop (Part of CarAds). All rights reserved.
 * @version   2026.01.20150259
 * @author    CarAds Team
 */
namespace CarShop\Basic;
/**
 * Trait DefaultSingleton
 *
 * @package CarShop\Basic
 */
trait AbstractSingleton
{
	/**
	 * @var self[]
	 */
	protected static array $instance = [];

    /**
     * @return self
     */
	public static function getInstance() : self
	{
		return static::$instance[static::class] ?? (self::$instance[static::class] = new static);
	}
}