<?php
/**
 * @copyright  Copyright (C) 2026 CarShop (Part of CarAds). All rights reserved.
 * @version   2026.01.20150259
 * @author    CarAds Team
 */
namespace CarShop\Basic;
use WP_Query;

/**
 * BasicController Class
 *
 */
abstract class BasicController
{
    /**
     * @var WP_Query
     */
    protected WP_Query $query;

    /**
     * @var DefaultRoute
     */
    protected DefaultRoute $route;

    /**
     * @var Seo
     */
    protected Seo $seo;

    /**
     * @var bool
     */
    protected bool $logged_in;
    public function __construct(Seo $seo, DefaultRoute $route)
    {
        global $wp_query;

        $this->query = $wp_query;
        $this->route = $route;
        $this->logged_in = is_user_logged_in();
        $this->seo = $seo;
    }

    abstract public function render();
}