<?php
/**
 * @copyright  Copyright (C) 2026 CarShop (Part of CarAds). All rights reserved.
 * @version   2026.01.20150259
 * @author    CarAds Team
 */
namespace CarShop\Basic;
use WP_REST_Request;

abstract class RestApi
{
    protected string $namespace = 'carads/nextgen';
    protected string $route;
    protected string $method = 'GET';

    use AbstractSingleton{
        getInstance as public addApi;
    }

    private function __construct()
    {
        add_action('rest_api_init', [$this, 'register'], 15);
    }


    protected function headers() : void
    {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE');
        header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
    }

    protected function basicArguments(): array
    {
        return [
            'methods' => $this->method,
            'callback' => [$this, 'run'],
            'cross_origin_allowed' => true,
        ];
    }

    public function register(): void
    {
        $args = method_exists($this, 'arguments') ? array_merge($this->basicArguments(), $this->arguments()) : $this->basicArguments();

        register_rest_route(
            $this->namespace,
            $this->route,
            $args
        );
    }

    abstract public function run(WP_REST_Request $request);
}