<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace Carshop\Controller;
use CarShop\Utils\BaseCatalogController;

class CatalogProductController extends  BaseCatalogController
{
    public function control() : void
    {
        $data = $this->fetch($this->route->active()->params->id ?? 0);

        if($data?->_status === 'error')
        {
            $this->query->is_404 = true;
            return;
        }

        $this->query->is_404 = false;
        $this->seo->title       = $data->product->name;
        $this->seo->description = $data?->product->data?->description ?? '';
        $this->seo->robots      = $this->config->robots;
    }


    private function fetch(int $id) : \stdClass{
        $http = new \WP_Http();
        $url = $this->config->type() === 'categories' ?
            "https://nextgen.carads.io/carshop/categories/item/{$this->config->cid}/{$id}" :
            "https://nextgen.carads.io/carshop/items/item/{$id}";

        $data = $http->get($url, [
            'timeout' => 5,
            'headers' => [
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            ]
        ]);

        if(is_wp_error($data)){
            return (object) [
                '_status' => 'error',
                '_message' => 'Unknown error'
            ];
        }

        $response   = (object) ($data['response'] ?? ['code' => 500]);

        if ($response->code === 200)
        {
            $body = json_decode($data['body'] ?? []);
            $body->_status = ($body?->product ?? null) !== null ? 'success' : 'error';

            return $body;
        }

        return (object) [
            '_status' => 'error',
            '_message' => 'Unknown error'
        ];
    }
}