<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop;
use CarShop\Basic\DefaultFactory;
use CarShop\Basic\Singleton;
use CarShop\Utils\Configs;
use CarShop\Utils\Route;
use CarShop\Utils\Settings;
use \Exception;

/**
 * Class Factory
 *
 * @property-read Settings $settings
 * @property-read Configs $configs
 * @property-read bool $c2Exists
 * @property-read bool $c2_exists - alias for $c2Exists
 * @property-read bool $carads_exists - alias for $c2Exists
 * @property-read Route $route
 * @property-read string $cdn_version
 * @property-read string $cdnVersion - alias for $cdn_version
 */
class Factory extends DefaultFactory
{
    use Singleton;
    private Configs $configs;

    private Settings $settings;

    private function settings() : Settings
    {
        return $this->settings ?? ($this->settings = new Settings());
    }

    private function configs(): Configs
    {
        return $this->configs ?? ($this->configs = new Configs(
            CARSHOP_TEST_PATH ? (CARSHOP_NEXTGEN_PATH . '/config') : (CARSHOP_NEXTGEN_PATH . '/../.carshop/')
        ));
    }

    private function c2_exists(): bool
    {
        return (
            is_plugin_active('c2/app.php') ||
            is_plugin_active('carads/app.php')
        );
    }

    private function route(): Route
    {
        return Route::getInstance();
    }

    private function cdn_version(): string
    {
        static $version;

        if($version){
            return $version;
        }

        $script     = $this->settings()->script;

        return ($version = $script);
    }

    /**
     * @throws Exception
     */
    public function __get(string $name): mixed
    {
        return match ($name) {
            'settings' => $this->settings(),
            'configs' => $this->configs(),
            'cdn_version', 'cdnVersion' => $this->cdn_version(),
            'c2Exists', 'c2_exists', 'carads_exists' => $this->c2_exists(),
            'route' => $this->route(),
            default => parent::__get($name),
        };
    }
}