<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version   2026.01.20150259
 * @author    CarAds Team
 */
namespace CarShop\RestApi;
use CarShop\Basic\RestApi;
use function CarShop\Basic\current_factory;
use function CarShop\Basic\isValidUuidV4;
use WP_REST_Request;

class HandShake extends RestApi
{
    protected string $route = 'handshake';
    protected string $method = 'POST';
    public function run(WP_REST_Request $request) : array
    {
        $this->headers();

        $params         = $request->get_params();
        $key            = $params['key'] ?? null;
        $domain         = $params['domain'] ?? null;
        $ca_secure_key  = current_factory()->settings->secure_key;

        if(empty($ca_secure_key)){
            return ['message' => 'invalid.sp-key'];
        }
        else if(!isValidUuidV4($ca_secure_key) || !isValidUuidV4($key) || $key !== $ca_secure_key)
        {
            return ['message' => 'invalid.sp-key'];
        }

        if ($domain !== get_site_url())
        {
            return ['message' => 'invalid.domain'];
        }

        if (empty($params['api_key']) || empty($params['company_id']))
        {
            return ['message' => 'invalid.api-key'];
        }
        else if(!isValidUuidV4($params['api_key'])){
            return ['message' => 'invalid.api-key'];
        }

        current_factory()->settings->update('cid', $params['company_id'], true, true);
        current_factory()->settings->update('api_key', $params['api_key'], true, true);

        return [
            'message'       => 'handshake.successful',
            'api_key'       => $params['api_key'],
            'company_id'    => $params['company_id'],
            'status'        => 'ok',
        ];
    }

    protected function arguments() : array{
        return [
            'args' => [
                'key' => [
                    'required' => true,
                    'type' => 'string',
                ],
                'company_id' => [
                    'required' => true,
                    'type' => 'string',
                ],
                'domain' => [
                    'required' => true,
                    'type' => 'string',
                ],
                'api_key' => [
                    'required' => true,
                    'type' => 'string',
                ]
            ]
        ];
    }
}