<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\RestApi;
use CarShop\Basic\RestApi;
use CarShop\Basic\UpdateConfig as BasicUpdateConfig;
use \WP_REST_Request;
use function CarShop\Basic\current_factory;
use function CarShop\Basic\isValidUuidV4;

class UpdateConfig extends RestApi
{
    protected string $route = 'update-config';
    protected string $method = 'POST';
    public function run(WP_REST_Request $request) : array
    {
        $this->headers();
        $secureKey      = (string) $_POST['secure_key'] ?? '';
        $caSecureKey    = (string) current_factory()->settings->api_key ?? '';

        if (!isValidUuidV4($secureKey) || !isValidUuidV4($caSecureKey) || $caSecureKey !== $secureKey) {
            return ['message' => 'invalid.key'];
        }

        $cid        = current_factory()->settings->cid;
        $response   = BasicUpdateConfig::sync($cid);
        $status     = BasicUpdateConfig::errorCodeMessages($response->status);

        return [
            'status' => $status
        ];
    }
}