<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Shortcode;
use CarShop\Basic\ElementorWidget;
use CarShop\Basic\Shortcode;
use CarShop\Utils\Enqueue;
use function CarShop\factory;
use function CarShop\Basic\render;

class Catalog extends Shortcode
{
    /**
     * @var string
     */
    protected string $tag = 'car-ads-slider-catalog';
    private static int $trigger = 0;

    public function render($args = [], $content = null) : string
    {
        $id = $args['id'] ?? null;

        if (!$id)
        {
            return 'You need add id to shortcode';
        }

        // {$id}_slider_catalog
        $config = factory()->configs->get($id . '_slider_catalog');

        if (!$config)
        {
            return 'no config found...';
        }

        self::$trigger++;

        if(factory()->settings->cid !== -1){
            $config->cid = factory()->settings->cid;
        }

        $configString   = json_encode($config);

        return render(CARSHOP_NEXTGEN_PATH . '/template-parts/slider_catalog.php', [
            'config' => $configString,
            'settings' => $config,
            'id' => $id,
            'trigger' => self::$trigger
        ]);
    }

    public function enqueue() : void{
        Enqueue::css(Enqueue::SLIDER_CATALOG);
    }

    public function elementor_register() : void{
        add_action('elementor/widgets/register', function($widgets_manager){
            $widgets_manager->register(new class extends ElementorWidget {
                protected string $title = 'CarShop Slider Catalog';
                protected string $icon = 'eicon-slider-album';
                protected string $tag = 'car-ads-slider-catalog';
                protected array $category = ['carads-widgets'];

                protected function register_controls() : void {
                    $this->start_controls_section(
                        'section_content',
                        [
                            'label' => __('Content', 'carshop'),
                        ]
                    );

                    $this->add_control(
                        'id',
                        [
                            'label' => __('Catalog ID', 'carshop'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'input_type' => 'text',
                            'placeholder' => __('Enter Catalog ID', 'carshop'),
                        ]
                    );

                    $this->end_controls_section();
                }

                protected function render(): void {
                    $settings = $this->get_settings_for_display();
                    echo do_shortcode('[car-ads-slider-catalog id="' . esc_attr($settings['id']) . '"]');
                }
            });
        });
    }
}