<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Utils;
use CarShop\Basic\BasicController;
use CarShop\Basic\DefaultRoute;
use CarShop\Basic\Seo;
use Carshop\Controller\CatalogController;
use CarShop\Utils\Configs\Catalog;
use JetBrains\PhpStorm\NoReturn;
use function CarShop\factory;
use function CarShop\Basic\render;

abstract class BaseCatalogController extends BasicController
{
    protected Catalog|null $config = null;
    public function __construct(Seo $seo, DefaultRoute $defaultRoute)
    {
        parent::__construct($seo, $defaultRoute);
        $this->config = factory()->configs->getCatalog(
            $this->route->active()->path
        );

        $this->useCacheCatalog();
    }

    public function useCacheCatalog() : void{
        // make cache folder by using CARSHOP_CACHE_PATH and mkdir if not exists
        $cache_path = CARSHOP_CACHE_PATH;
        if(!file_exists($cache_path)){
            mkdir($cache_path, 0755, true);
        }

        $filename = $cache_path . '/' . $this->route->to_cache_file();

        // if file exists and is less than 60 minutes old, use it
        if(!is_user_logged_in() && file_exists($filename) && (time() - filemtime($filename) < 3600)){
            status_header(200, 'OK');
            echo file_get_contents($filename);
            die;
        }
    }



    abstract protected function control();


    #[NoReturn] public function render() : void
    {
        $this->control();

        if($this->query?->is_404)
        {
            $this->query->set_404();
            status_header(404);
            return;
        }

        status_header(($this->query->is_404 ? 404 : 200), ($this->query->is_404 ? 'Not Found' : 'OK'));

        Enqueue::catalog($this->config);

        $this->doCache(function(){
            get_header();

            echo render(CARSHOP_NEXTGEN_PATH . '/template-parts/products.php', [
                'config' => $this->config,
                'base_url' => trim($this->route->active()->base ?? '', '/'),
            ]);

            get_footer();
        });
        die;
    }

    private function doCache($callback) : void{
        ob_start();
        $callback();
        $output = ob_get_clean();

        $cache_path = CARSHOP_CACHE_PATH;
        $filename = $cache_path . '/' . $this->route->to_cache_file();

        if(!is_user_logged_in()){
            file_put_contents($filename, $output);
        }

        echo $output;
    }
}