<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Utils;
use CarShop\Basic\Configs as BasicConfigs;
use CarShop\Utils\Configs\Catalog;

class Configs extends BasicConfigs
{
    protected array $cacheConfig = [];
    public function catalogOnly() : array{
        return array_map(function($item){
            return str_replace('_catalog', '', $item);
        }, array_filter(array_values($this->configFiles), function($name){
            return str_ends_with($name, '_catalog') && !str_ends_with($name, 'slider_catalog');
        }));
    }

    public function get(string $name, $setDefault = null) : mixed
    {
        if(array_key_exists($name, $this->cacheRawConfig)){
            return $this->cacheConfig[$name]?:$setDefault;
        }

        $this->cacheConfig[$name] = $this->_instance($name);

        return $this->cacheConfig[$name]?:$setDefault;
    }

    public function getCatalog(string $name) : ?Catalog
    {
        return $this->get("{$name}_catalog", null);
    }

    private function _instance(string $name) : ?object
    {
        $rawConfig  = $this->offsetGet($name);
        $config     = $rawConfig ? json_decode($rawConfig) : null;

        switch ($name) {
            case 'settings':
                return new Configs\Settings($config ?? (object)[]);
            default:
                if (str_ends_with($name, 'slider_catalog')) {
                    return new Configs\Slider($config ?? (object)[]);
                } else if (str_ends_with($name, '_catalog')) {
                    return new Catalog($config ?? (object)[]);
                }

                return $config;
        }
    }
}