<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Utils\Configs;

use Exception;

readonly class Catalog implements \JsonSerializable
{
    const int CATEGORIES = 1;
    const int PRODUCTS = 2;

    readonly public int $cid;
    readonly public ?int $fid;
    readonly array $filters;

    readonly string $title;

    readonly string $description;

    readonly string $robots;

    readonly int $type;

    readonly string $theme;

    readonly protected object $all;

    readonly object $disabled_field;

    readonly object $translate;

    readonly object $item;

    public function __construct(\stdClass $config){
        $this->cid              = isset($config->cid) ? (int) $config->cid : -1;
        $this->fid              = isset($config->fid) ? (int) $config->fid : null;
        $this->filters          = (array) ($config?->filters ?? []);
        $this->title            = empty($config->title) ? 'CarSHOP' : $config->title;
        $this->description      = empty($config->description) ? 'CarSHOP' : $config->description;
        $this->disabled_field   = $config->disabled_field ?? new \stdClass();
        $this->translate        = $config->translate ?? new \stdClass();
        $this->item             = $config->item ?? new \stdClass();
        $this->robots           = empty($config->robots) ? 'index, follow' : $config->robots;

        if($this->fid === null){
            $this->type = static::CATEGORIES;
        }
        else {
            $this->type = static::PRODUCTS;
        }

        // allow theme - light, deep
        if (!empty($config->theme) && !in_array($config->theme, ['light', 'deep'])) {
            $this->theme = 'light';
        }
        else {
            $this->theme = empty($config->theme) ? 'light' : $config->theme;
        }

        // ignore all properties that are defined in the class
        foreach ($config as $key => $value) {
            if (property_exists($this, $key)) {
                unset($config->$key);
            }
        }

        $this->all = $config;
    }

    public function type(): string
    {
        return $this->type === static::CATEGORIES ? 'categories' : 'products';
    }

    /**
     * @throws Exception
     */
    public function __get(string $name)
    {
        if (property_exists($this, $name)) {
            return $this->$name;
        }
        else if (property_exists($this->all, $name)) {
            return $this->all->$name;
        }

        throw new Exception("Property $name does not exist");
    }
    public function __isset(string $name): bool
    {
        return property_exists($this, $name) || property_exists($this->all, $name);
    }

    public function jsonSerialize(): mixed
    {
        $ob = (array) get_object_vars($this);
        $all = (array) get_object_vars($this->all);
        unset($ob['all']);
        return (object) array_merge($all, $ob);
    }
}