<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Utils;
use function CarShop\Basic\css_inject_helper;

class Enqueue
{
    const int SLIDER_CATALOG = 1;
    const int OPENING_TIMES  = 2;

    static public function catalog(object $settings): void
    {
        $type           = $settings->type();

        $files = [
            'catalog'           => 'catalog/catalog.css',
            'catalog_item'      => 'catalog/item.css',
            'lightbox'          => 'lightbox.css',
            'form_filter'       => 'forms/filters.css',
            'range'             => 'range.css',
            'filter_sort'       => 'filter/sort.css',
            'car-ads-icons'     => 'icons.css',
        ];

        if (count($settings->filters) > 0){
            $files['filter_deep']       = 'filter/deep.css';
            $files['filter_classic']    = 'filter/classic.css';
        }

        if($type === 'categories'){
            $files['catalog_search_categories'] = 'catalog/list/categories.css';
        }
        else {
            $files['catalog_search_products'] = 'catalog/list/products.css';
        }

        if(($settings?->search?->plans ?? false)){
            $files['catalog_search_plans'] = 'catalog/list/complex.css';
        }


        foreach ($files as $basename => $file)
        {
            wp_enqueue_style('car-ads-' . $basename, css_inject_helper($file), []);
        }
    }

    public static function css(int $type): void
    {
        $files = self::addCssFile($type);

        foreach ($files as $basename => $file)
        {
            $basename = 'car-ads-' . $basename;
            wp_enqueue_style($basename, css_inject_helper($file), []);
        }
    }


    static private function addCssFile(int $type):array{
        return match ($type) {
            self::SLIDER_CATALOG => [
                'swiper' => 'swiper.css',
                'catalog_slider' => 'catalog/slider.css',
                'catalog_search' => 'catalog/search.css',
                'car-ads-icons'  => 'icons.css',
            ],
            self::OPENING_TIMES  => [
                'opening-times'     => 'department/opening_times/basic.css',
            ],
            default => [],
        };
    }
}