<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Utils;

use CarShop\Basic\DefaultRoute;
use CarShop\Basic\Singleton;
use CarShop\Utils\Configs\Settings;
use CarShop\Vendor\FastRoute\Dispatcher;
use CarShop\Vendor\FastRoute\RouteCollector;
use function CarShop\factory;
use function CarShop\Vendor\FastRoute\simpleDispatcher;

class Route implements DefaultRoute
{
    use Singleton;

    public Dispatcher $dispatcher;

    public ?object $active;

    private array $rewrite = [];
    private array $tags = [
        '%carshop%', '([^?]+)',
        '%slug%', '([^?]+)',
        '%id%', '([0-9]+)',
        '%namespace%', '([^?]+)',
    ];

    private function __construct()
    {
        $this->register_dispatcher();
    }

    private function settings(): Settings
    {
        return factory()->configs->get('settings');
    }

    private function routes(): array{
        return factory()->configs->catalogOnly();
    }

    private function register_dispatcher() : void
    {
        $prefix             = $this->settings()->prefix;
        $paths              = $this->routes();

        $this->dispatcher   = simpleDispatcher(function (RouteCollector $r) use($prefix, $paths) {
            $allow_any      = is_customize_preview();
            $get            = $allow_any ? '*' : 'GET';

            foreach ($paths as $path){
                $namespace = "{$path}-{$prefix}";
                $base = count($paths) === 1 ? "/{$prefix}" : "/{$path}-{$prefix}";
                $r->addGroup($base, function (RouteCollector $r) use($get, $path, $namespace, $base) {
                    $r->addRoute($get, "", (object)[
                        'carshop'   => 'catalog-list',
                        'namespace' => $namespace,
                        'path' => $path,
                        'base' => $base,
                    ]);
                    $this->rewrite[] = ["{$path}$", 'index.php?carshop=catalog-list&namespace=' . $namespace];
                    $r->addRoute($get, '/{slug}-{id}', (object)[
                        'carshop'   => 'catalog-product',
                        'namespace' => $namespace,
                        'path'      => $path,
                        'base'      => $base,
                    ]);
                    $this->rewrite[] = ["{$path}/([^/]+)-([0-9]+)$", 'index.php?carshop=catalog-product&slug=$matches[1]&id=$matches[2]&namespace=' . $namespace];
                });
            }
            return $r;
        });
        $this->active       = $this->register();
    }
    /**
     * @return void
     *
     */
    public function register_rewrites() : void
    {
        foreach ($this->tags as $tag){
            add_rewrite_tag( $tag[0], $tag[1] );
        }

        foreach ($this->rewrite as $rule){
            add_rewrite_rule($rule[0], $rule[1], $rule[2] ?? 'top');
        }
    }

    /**
     * @return object|null
     */
    private function register(): ?object
    {
        $info = $this->dispatcher->dispatch(
            $_SERVER['REQUEST_METHOD'],
            factory()->url
        );

        return match ($info[0]) {
            Dispatcher::FOUND => (object)[
                'carshop' => $info[1]->carshop,
                'namespace' => $info[1]->namespace,
                'path' => $info[1]->path,
                'base' => $info[1]->base,
                'params' => (object)($info[2] ?? []),
            ],
            default => null,
        };
    }

    public function active(): ?object
    {
        return $this->active;
    }

    public function to_cache_file(): ?string
    {
        if(!$this->active()){
            return null;
        }

        if($this->active->carshop === 'catalog-product'){
            return $this->active()->namespace . '-' . md5($this->active()->params->id);
        }

        return $this->active()->namespace . '-list';
    }
}