<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Utils;
use ElementorPro\Modules\ThemeBuilder\Conditions\Condition_Base;
use function CarShop\factory;

class ViewCondition extends Condition_Base
{
    public static function get_type(): string
    {
        return 'carshop';
    }

    public static function get_priority(): int {
        return 40;
    }

    public function get_label(): ?string
    {
        return __( 'CarSHOP', 'CarAdsLight' );
    }

    public function get_name(): string
    {
        return 'carshop_view';
    }

    public function get_all_label(): string {
        return __( 'CarSHOP', 'CarAdsLight' );
    }

    /**
     * @param $args
     * @return bool
     */
    public function check( $args ): bool {
        return factory()->route->active !== null;
    }
}