<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */
namespace CarShop\Wordpress;

use CarShop\Basic\CustomizeHelper;
use CarShop\Basic\Singleton;
use WP_Customize_Manager;
use function CarShop\factory;

class Customize
{
    use Singleton;

    private function __construct()
    {
        add_action('customize_register', [$this, 'register'], 1, 99);
    }

    public function register(WP_Customize_Manager $customize) : void{
        $panel = CustomizeHelper::panel(
            customize: $customize,
            key: 'carshop_settings',
            title: __( 'CarSHOP Indstillinger', 'CarSHOP' ),
        );

        $this->general($customize, $panel);
        $this->shop($customize, $panel);
    }

    public function shop(WP_Customize_Manager $customize, $panel) : void
    {
        $section = CustomizeHelper::Section(__( 'Shop', 'CarSHOP' ), $panel->id, $customize);

        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarShopThirdPartySeo',
            label: __( 'Tredjeparts SEO', 'CarSHOP' ),
            default: false,
            section: $section->id,
            description: __('Aktiver denne indstilling for at tillade tredjeparts SEO værktøjer at indeksere CarSHOP indhold på din hjemmeside.', 'CarSHOP')
        );
    }

    private function general(WP_Customize_Manager $customize, $panel) : void
    {
        if(factory()->c2Exists){
            return;
        }

        $section = CustomizeHelper::Section(__( 'Globale', 'CarSHOP' ), $panel->id, $customize);

        CustomizeHelper::Text(
            customize: $customize,
            key: 'CarShopClientID',
            label: __( 'Client ID', 'CarSHOP' ),
            default: '-1',
            section: $section->id,
            description: __('Indtast dit CarSHOP Client ID her. Du kan finde dit Client ID i din CarSHOP konto under "API Indstillinger".', 'CarSHOP')
        );

        CustomizeHelper::Text(
            customize: $customize,
            key: 'CarShopApiKey',
            label: __( 'API Nøgle', 'CarSHOP' ),
            default: '',
            section: $section->id,
            description: __('Indtast din CarSHOP API Nøgle her. Du kan finde din API Nøgle i din CarSHOP konto under "API Indstillinger".', 'CarSHOP')
        );
        CustomizeHelper::Text(
            customize: $customize,
            key: 'CarShopSecureKey',
            label: __( 'Sikker Nøgle', 'CarSHOP' ),
            default: '',
            section: $section->id,
            description: __('Indtast din CarSHOP Sikker Nøgle her. Du kan finde din Sikker Nøgle i din CarSHOP konto under "API Indstillinger".', 'CarSHOP')
        );

        CustomizeHelper::Select(
            customize: $customize,
            key: 'CarShopScript',
            label: __( 'Script Version', 'CarSHOP' ),
            default: 'master',
            choices: [
                'master' => 'Master',
                'develop' => 'Develop',
                'tester' => 'Tester',
            ],
            section: $section->id,
            description: __('Vælg hvilken version af CarSHOP scriptet der skal bruges på din hjemmeside.', 'CarSHOP')
        );

        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarShopCarleadEnabled',
            label: __( 'Aktiver CarLead Integration', 'CarSHOP' ),
            default: false,
            section: $section->id,
            description: __('Aktiver denne indstilling for at integrere CarLead funktionalitet på din hjemmeside.', 'CarSHOP')
        );

        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarShopOptimizeAssets',
            label: __( 'Optimer Assets', 'CarSHOP' ),
            default: false,
            section: $section->id,
            description: __('Aktiver denne indstilling for at optimere indlæsningen af CarSHOP assets på din hjemmeside.', 'CarSHOP')
        );

        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarShopShadowRoot',
            label: __( 'Brug Shadow DOM', 'CarSHOP' ),
            default: false,
            section: $section->id,
            description: __('Aktiver denne indstilling for at bruge Shadow DOM til CarSHOP komponenter på din hjemmeside.', 'CarSHOP')
        );
    }
}