<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 * @version 2026.01.20150259
 * @author CarAds Team
 */

use CarShop\RestApi\HandShake;
use CarShop\RestApi\AllConfigs;
use CarShop\RestApi\UpdateConfig;
use CarShop\Shortcode\Catalog as CatalogShortcode;
use CarShop\Shortcode\Contact;
use CarShop\Shortcode\OpeningTimes;
use CarShop\Utils\Wordpress;
use CarShop\Wordpress\Customize;
use CarShop\Wordpress\Rewrite;
use function CarShop\Basic\simpleUpdater;
use function CarShop\factory;

return new class{
    public function __construct()
    {
        Wordpress::init();
        Customize::getInstance();
        Rewrite::getInstance();

        $this->shortcode();
        $this->api();
        $this->register();
    }

    private function register() : void
    {
        add_filter('carads_config_files', function($files){
            return array_merge($files, ['carshop' => factory()->configs]);
        });

        simpleUpdater(
            url: 'https://download.js.nextgen.carads.io/carshop-update.json',
            version: CARSHOP_NEXTGEN_VERSION,
            base: CARSHOP_NEXTGEN_BASE,
            icons: [
                '1x' => CARSHOP_NEXTGEN_URL . 'assets/256.png',
                '2x' => CARSHOP_NEXTGEN_URL . 'assets/icon.png',
                'default' => CARSHOP_NEXTGEN_URL . 'assets/128.png',
            ],
            only_testing: CARSHOP_TEST
        );
    }

    private function shortcode(): void
    {
        CatalogShortcode::addShortcode()
            ->elementor_register();
        OpeningTimes::addShortcode()
            ->elementor_register();
        Contact::addShortcode()
            ->elementor_register();
    }
    private function api(): void{
        if (!factory()->c2_exists){
            HandShake::getInstance();
            UpdateConfig::getInstance();
            AllConfigs::getInstance();
        }
    }
};