<?php
/**
 * @copyright  Copyright (C) 2026 CarSHOP (Part of CarAds) All rights reserved.
 */

use CarShop\Utils\Configs\Catalog;
use function CarShop\Basic\createAttributes;
/**
 * @var Catalog $config
 * @var array $other_lists
 * @var string $base_url
 */

defined('ABSPATH') or die('');

$attr = createAttributes([
    'id' => 'app-catalog',
    'data-time' => CARSHOP_TIME,
    'data-version' => '2',
    'data-release' => CARSHOP_NEXTGEN_VERSION,
    'data-base-url' => $base_url,
    'data-url' => site_url($base_url),
    'carads-catalog' => 'search',
    'style' => 'min-height: 90vh;',
    'class' => $config->theme
]);
?>
<div class="carads">
    <div <?php echo $attr; ?>></div>
    <script type="application/json" id="catalog-settings"><?php echo json_encode($config); ?></script>
</div>