<?php
/**
 * @copyright  Copyright (C) 2026 . All rights reserved.
 * @version   2026.01.20082522
 * @author    CarAds Team
 */
namespace CarAdsDealership\Basic;
/**
 * Trait DefaultSingleton
 *
 * @package CarAdsDealership\Basic
 */
trait AbstractSingleton
{
	/**
	 * @var self[]
	 */
	protected static array $instance = [];

    /**
     * @return self
     */
	public static function getInstance() : self
	{
		return static::$instance[static::class] ?? (self::$instance[static::class] = new static);
	}
}