<?php
/**
 * @copyright  Copyright (C) 2026 . All rights reserved.
 * @version   2026.01.20082522
 * @author    CarAds Team
 */
namespace CarAdsDealership\Basic;
use stdClass;

/**
 * Class Shortcode
 *
 * @package Wheelster\Abstracts
 */
abstract class Shortcode
{
    CONST int ENQUEUE_METHOD_DEFAULT = 1;
    const int ENQUEUE_METHOD_FULL_CONTROL = 2;
	use AbstractSingleton{
		getInstance as public addShortcode;
	}

	/**
	 * @var string
	 */
	protected string $tag;
    protected int $enqueue_hook = self::ENQUEUE_METHOD_DEFAULT;

	final protected function __construct()
	{
        if(shortcode_exists($this->tag)){
            return;
        }

        add_shortcode($this->tag, [$this, 'render']);

        $this->magicEnqueue();

        if (method_exists($this, 'init'))
        {
            $this->init();
        }
	}

	abstract public function render() : string;


    private function magicEnqueue() : void{
        if(!method_exists($this, 'enqueue')) {
            return;
        }

        add_action('wp_enqueue_scripts', function(){
            // add scripts and styles if shortcode is added to the page
            if (has_shortcode(get_the_content(), $this->tag))
            {
                if($this->enqueue_hook === self::ENQUEUE_METHOD_DEFAULT){
                    call_user_func([$this, 'enqueue']);
                }
                else if($this->enqueue_hook === self::ENQUEUE_METHOD_FULL_CONTROL){
                    call_user_func_array([$this, 'enqueue'], [$this->shortcodeAttrAndValue(get_the_content())]);
                }
            }
        });
    }

    protected function shortcodeAttrAndValue($content) : stdClass{
        preg_match_all( '@\[([^<>&/\[\]\x00-\x20=]++)@', $content, $matches );
        $tag_names = array_intersect( [$this->tag], $matches[1] );
        $pattern = get_shortcode_regex( $tag_names );

        $tmp = [];
        $numberOfMatchs = 0;

        if(@preg_match_all("/$pattern/", $content, $matches)){
            $attrs = array_map(function($value){
                return shortcode_parse_atts($value);
            }, $matches[3]);

            $numberOfMatchs = count($attrs);

            foreach ($attrs as $index => $value){
                $tmp[$value['id']] = [
                    'attr' => $value,
                    'value' => $matches[5][$index] ?? []
                ];
            }
        }

        return (object)[
            'list' => $tmp,
            'count' => $numberOfMatchs
        ];
    }
}