<?php

namespace CarAdsDealership;
use CarAdsDealership\Basic\DefaultFactory;
use CarAdsDealership\Basic\Singleton;
use CarAdsDealership\Utils\Configs;
use CarAdsDealership\Utils\Route;
use CarAdsDealership\Utils\Settings;
use \Exception;

/**
 * @property-read  bool $c2_exists
 * @property-read  bool $c2Exists alias of c2_exists
 * @property-read  bool $carads_exists alias of c2_exists
 * @property-read  bool $carshop_exists
 * @property-read  bool $lite_exists
 * @property-read Configs $configs
 * @property-read Settings $settings
 * @property-read Route $route
 *
 */
class Factory extends DefaultFactory
{
    use Singleton;

    /**
     * @throws Exception
     */

    private Configs $configs;
    private Settings $settings;

    private function c2_exists(): bool
    {
        return (
            is_plugin_active('c2/app.php') ||
            is_plugin_active('carads/app.php')
        );
    }

    private function carshop_exists(): bool
    {
        return is_plugin_active('carshop/app.php');
    }

    private function lite_exists(): bool
    {
        return is_plugin_active('carads-lite/app.php');
    }

    private function configs(): Configs
    {
        return $this->configs ?? ($this->configs = new Configs(
            CA_DEALERSHIP_TEST_PATH ? (CA_DEALERSHIP_DIR . '/config') : (CA_DEALERSHIP_DIR . '/../.dealership/')
        ));
    }

    private function route(): Route
    {
        return Route::getInstance();
    }

    private function settings(): Settings
    {
        return $this->settings ?? ($this->settings = new Settings());
    }

    public function __get(string $name): mixed
    {
        return match ($name) {
            'settings' => $this->settings(),
            'configs' => $this->configs(),
            'c2Exists', 'c2_exists', 'carads_exists' => $this->c2_exists(),
            'carshop_exists' => $this->carshop_exists(),
            'lite_exists' => $this->lite_exists(),
            'route' => $this->route(),
            default => parent::__get($name),
        };
    }
}