<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082522
 * @author CarAds Team
 */
namespace CarAdsDealership\RestApi;
use CarAdsDealership\Basic\RestApi;
use CarAdsDealership\Basic\UpdateConfig as BasicUpdateConfig;
use \WP_REST_Request;
use function CarAdsDealership\Basic\current_factory;
use function CarAdsDealership\Basic\isValidUuidV4;

class UpdateConfig extends RestApi
{
    protected string $route = 'update-config';
    protected string $method = 'POST';
    public function run(WP_REST_Request $request) : array
    {
        $this->headers();
        $secureKey      = (string) $_POST['secure_key'] ?? '';
        $caSecureKey    = (string) current_factory()->settings->api_key ?? '';

        if (!isValidUuidV4($secureKey) || !isValidUuidV4($caSecureKey) || $caSecureKey !== $secureKey) {
            return ['message' => 'invalid.key'];
        }

        $cid        = current_factory()->settings->cid;
        $response   = BasicUpdateConfig::sync($cid);
        $status     = BasicUpdateConfig::errorCodeMessages($response->status);

        return [
            'status' => $status
        ];
    }
}