<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082522
 * @author CarAds Team
 */
namespace CarAdsDealership\Shortcode;
use CarAdsDealership\Basic\ElementorWidget;
use CarAdsDealership\Basic\Shortcode;

/**
 * Class QuickSearch
 */
class DealerSlider extends Shortcode
{
	/**
	 * @var string
	 */
	protected string $tag = 'car-ads-dealer-slider';

	public function render($args = [], $content = null) : string
	{
        $config = @json_decode(trim($content));

        if(json_last_error() !== JSON_ERROR_NONE)
        {
            return 'You need add config to shortcode';
        }

        $config = json_encode($config, JSON_PRETTY_PRINT);

        return $this->innerHtml($config);
	}

    private function innerHtml(string $config):string{
        $time = CA_TIME;
        return <<<HTML
            <div class="ca-dealer" data-time="{$time}">
                <div class="carads_dealder_slider" data-settings='{$config}'>
                </div>
            </div>
HTML;
    }

    public function elementor_register() : void{
        add_action('elementor/widgets/register', function($widgets_manager) {
            $widgets_manager->register(new class extends ElementorWidget{
                protected string $title = 'CarWeb Dealer Slider';
                protected string $tag = 'CarAdsDealerSlider';
                protected string $icon = 'eicon-search';
                protected array $category = ['carads-widgets'];

                protected function render() : void{
                    $s = $this->get_settings_for_display();

                    $json = $s['config'] ?? '{}';

                    echo do_shortcode('[car-ads-dealer-slider]' . $json . '[/car-ads-dealer-slider]');
                }
                protected function register_controls(): void
                {
                    $this->start_controls_section('section_content',[
                        'label' => __('Content', 'CarAdsNextgen'),
                    ]);

                    $this->add_control('config', [
                        'label' => __('Slider Config (JSON)', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => '{}',
                        'description' => __('Enter the slider configuration in JSON format.', 'CarAdsNextgen'),
                    ]);

                    $this->end_controls_section();
                }
            });
        });
    }
}