<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082522
 * @author CarAds Team
 */
namespace CarAdsDealership\Shortcode;
use CarAdsDealership\Basic\ElementorWidget;
use CarAdsDealership\Basic\Shortcode;
use function CarAdsDealership\Basic\css_inject_helper;
use function CarAdsDealership\factory;

class Maps extends Shortcode
{
    protected string $tag = 'carads-dealer-map';

    public function render($args = [], $content = null): string
    {
        $config = new \stdClass;

        if ($content !== null) {
            $config = @json_decode(trim($content));
        }

        if (json_last_error() !== JSON_ERROR_NONE) {
            return 'You need add config to shortcode';
        }

        if (factory()->settings->cid !== -1) {
            $config->cid = factory()->settings->cid;
        }

        return $this->innerHtml(json_encode($config));
    }

    public function enqueue(): void
    {
        wp_enqueue_style('car-ads-department-map', css_inject_helper('department/maps.css'), []);
    }


    private function innerHtml(string $config):string{
        return <<<HTML
            <div id="carads-map" data-version="2" class="carads"></div>
            <script type="application/json" id="carads_map_settings">
            {$config}
            </script>
HTML;
    }


    public function elementor_register() : void{
        add_action('elementor/widgets/register', function($widgets_manager) {
            $widgets_manager->register(new class extends ElementorWidget{
                protected string $title = 'CarWeb Dealer Map';
                protected string $tag = 'CarAdsDealerMap';
                protected string $icon = 'eicon-search';
                protected array $category = ['carads-widgets'];

                protected function render() : void{
                    $s = $this->get_settings_for_display();

                    $json = $s['config'] ?? '{}';

                    echo do_shortcode('[carads-dealer-map]' . $json . '[/carads-dealer-map]');
                }
                protected function register_controls(): void
                {
                    $this->start_controls_section('section_content',[
                        'label' => __('Content', 'CarAdsNextgen'),
                    ]);

                    $this->add_control('config', [
                        'label' => __('Slider Config (JSON)', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => '{}',
                        'description' => __('Enter the slider configuration in JSON format.', 'CarAdsNextgen'),
                    ]);

                    $this->end_controls_section();
                }
            });
        });
    }
}
