<?php

namespace CarAdsDealership\Utils;
use CarAdsDealership\Basic\Configs as ConfigsBasic;
use CarAdsDealership\Utils\Configs\Settings as ConfigsSettings;

class Configs extends ConfigsBasic
{
    protected array $cacheConfig = [];

    public function get(string $name, $setDefault = null) : mixed
    {
        if(array_key_exists($name, $this->cacheConfig)){
            return $this->cacheConfig[$name]?:$setDefault;
        }

        $this->cacheConfig[$name] = $this->_instance($name);

        return $this->cacheConfig[$name]?:$setDefault;
    }

    private function _instance(string $name) : mixed
    {
        $rawConfig  = $this->offsetGet($name);

        $config     = $rawConfig ? json_decode($rawConfig) : null;

        return match ($name) {
            'settings' => new ConfigsSettings($config ?? (object)[]),
            default => $this->other($name, $config),
        };
    }

    private function other(string $name, mixed $config) : mixed{
        return $config;
    }
}