<?php

namespace CarAdsDealership\Utils;

use CarAdsDealership\Basic\DefaultRoute;
use CarAdsDealership\Basic\Singleton;
use CarAdsDealership\Vendor\FastRoute\Dispatcher;
use CarAdsDealership\Utils\Configs\Settings as ConfigsSettings;
use CarAdsDealership\Vendor\FastRoute\RouteCollector;
use function CarAdsDealership\factory;
use function CarAdsDealership\Vendor\FastRoute\simpleDispatcher;

class Route implements DefaultRoute
{
    use Singleton;

    public Dispatcher $dispatcher;

    public ?object $active;

    private array $rewrite = [];

    private array $tags = [
        '%carads%' => '([^?]+)',
        '%slug%' => '([^?]+)',
        '%namespace%' => '([^?]+)',
    ];

    private function __construct()
    {
        $this->register_dispatcher();
    }

    public function active(): ?object
    {
        return $this->active;
    }

    public function register_rewrites(): void
    {
        // TODO: Implement register_rewrites() method.
    }
    private function settings(): ConfigsSettings
    {
        return factory()->configs->get('settings');
    }

    private function register_dispatcher() : void{
        $prefix             = $this->settings()->prefix;

        $this->dispatcher   = simpleDispatcher(function (RouteCollector $r) use($prefix) {
            $allow_any = is_customize_preview();
            $get = $allow_any ? '*' : 'GET';

            if(!factory()->configs->exists('dealer')) {
                return;
            }

            $dealer_config  = factory()->configs->get('dealer');

            if($dealer_config->cid){
                $r->addRoute($get, "/{$prefix}", (object)[
                    'carads'    => 'dealer-list',
                    'namespace' => 'dealer'
                ]);
                $this->rewrite[] = ["{$prefix}$", 'index.php?carads=dealer-list'];
                $r->addRoute($get, "/{$prefix}/{slug}", (object)[
                    'carads'    => 'dealer-detail',
                    'namespace' => 'dealer'
                ]);
                $this->rewrite[] = ["^{$prefix}/([^/]+)$", 'index.php?carads=dealer-detail&slug=$matches[1]'];
            }
        });

        $this->active = $this->register();
    }
    /**
     * @return object|null
     */
    private function register(): ?object{
        $info = $this->dispatcher->dispatch(
            $_SERVER['REQUEST_METHOD'],
            factory()->url
        );

        return match ($info[0]) {
            Dispatcher::FOUND => (object)[
                'controller' => $info[1]->carads,
                'namespace' => $info[1]->namespace,
                'path' => $info[1]->path ?? '',
                'params' => (object)($info[2] ?? []),
            ],
            default => null,
        };
    }
}