<?php

namespace CarAdsDealership\Wordpress;
use CarAdsDealership\Basic\Seo;
use CarAdsDealership\Basic\Singleton;
use CarAdsDealership\Controller\DealerController;
use CarAdsDealership\Controller\DealersController;
use CarAdsDealership\Utils\Route;
use function CarAdsDealership\factory;

class Rewrite
{
    use Singleton;

    const array CONTROLLER = [
        'dealer-list'       => DealersController::class,
        'dealer-detail'     => DealerController::class,
    ];

    private function __construct()
    {
        $route = factory()->route;

        add_action('init', function () use($route) {
            $route->register_rewrites();   // Register custom rewrite rules.
            if ($route->active()) {
                $this->render($route);
            }
        });
    }

    private function render(Route $route): void
    {
        $active = $route->active();
        $this->optimizeTemplateRedirect();

        if(!isset(self::CONTROLLER[$active->controller])){
            return;
        }

        $seo = new Seo(['3rd_party_seo_active' => false]);

        add_action('template_redirect', function() use($active, $seo){
            $controller = self::CONTROLLER[$active->controller];
            (new $controller($seo, factory()->route))->render();
        }, 99);
    }

    /**
     * Removes default WordPress template redirect actions that may interfere with custom routing.
     * If the `c2Exists` flag is set in the factory, the function exits early.
     * Otherwise, it hooks into `template_redirect` at priority 9 and unsets
     * `wp_old_slug_redirect` and `redirect_canonical` from the filter stack.
     */
    protected function optimizeTemplateRedirect() : void
    {
        /** @noinspection DuplicatedCode */
        add_action('template_redirect', function(){
            /**  */
            global $wp_filter, $wp_filters;

            $tmp = $wp_filter['template_redirect'][10];
            foreach($tmp AS $key => $value){
                if($value['function'] === 'wp_old_slug_redirect'){
                    unset($tmp[$key]);
                }
                if($value['function'] === 'redirect_canonical'){
                    unset($tmp[$key]);
                }
            }

            $wp_filter['template_redirect'][10] = $tmp;
        }, 9);
    }
}