<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082522
 * @author CarAds Team
 */
spl_autoload_register(function ($class) {
    $prefix = 'CarAdsDealership\\';
    $base_dir = __DIR__ . '/../includes/';
    $len = strlen($prefix);

    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

include_once __DIR__ . '/_global.php';
include_once __DIR__ . '/Basic/_functions.php';
include_once __DIR__ . '/Vendor/FastRoute/functions.php';