<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082522
 * @author CarAds Team
 */
use CarAdsDealership\RestApi\AllConfigs;
use CarAdsDealership\RestApi\HandShake;
use CarAdsDealership\RestApi\UpdateConfig;
use CarAdsDealership\Wordpress\Rewrite;
use function CarAdsDealership\Basic\simpleUpdater;
use function CarAdsDealership\factory;
use CarAdsDealership\Shortcode\Maps;
use CarAdsDealership\Shortcode\DealerSlider;

return new class {
    public function __construct()
    {
        $this->upgrader();
        $this->requirements();
        $this->shortcodes();
        $this->register();
        $this->api();
        Rewrite::getInstance();
    }

    private function api(): void
    {
        if (!(factory()->c2_exists || factory()->carshop_exists)) {
            HandShake::getInstance();
            UpdateConfig::getInstance();
            AllConfigs::getInstance();
        }

    }

    private function register() : void{
        add_filter('carads_config_files', function($files){
            return array_merge($files, ['dealership' => factory()->configs]);
        });
    }

    private function shortcodes(): void
    {
        if (!(factory()->c2_exists || factory()->lite_exists)) {
            return;
        }

        Maps::addShortcode()
            ->elementor_register();
        DealerSlider::addShortcode()
            ->elementor_register();
    }

    private function requirements(): void
    {
        // this plugin need carads or carads lite to be running - show admin notice if not found
        if(factory()->c2_exists || factory()->lite_exists){
            return;
        }

        add_action('admin_notices', function () {
            ?>
            <div class="notice notice-error is-dismissible">
                <p>
                    <?php
                    printf(
                        esc_html__('The %1$s plugin requires the %2$s or %3$s plugin to be installed and activated.', 'carads-dealership'),
                        '<strong>' . esc_html__('CarAds Dealership', 'carads-dealership') . '</strong>',
                        '<strong>' . esc_html__('CarAds', 'carads-dealership') . '</strong>',
                        '<strong>' . esc_html__('CarAds Lite', 'carads-dealership') . '</strong>'
                    );
                    ?>
                </p>
            </div>
            <?php
        });
    }

    private function upgrader(): void
    {
        if(defined('CA_DEALERSHIP_TEST') && CA_DEALERSHIP_TEST){
            return;
        }

        simpleUpdater(
            url: 'https://download.js.nextgen.carads.io/dealership-update.json',
            version: CA_DEALERSHIP_VERSION,
            base: CA_DEALERSHIP_BASE,
            icons: [
                '1x' => CA_DEALERSHIP_URL . 'assets/256.png',
                '2x' => CA_DEALERSHIP_URL . 'assets/icon.png',
                'default' => CA_DEALERSHIP_URL . 'assets/128.png',
            ]
        );
    }
};